/* On Windows not all versions of VS support C++11 and
 * some (most?) versions of mingw don't support std::thread,
 * even though they do support c++11. Since we only care about
 * threads working, do the test with raw win threads.
 */

#if defined _WIN32

#include<windows.h>
#include<stdio.h>

DWORD WINAPI thread_func(LPVOID) {
    printf("Printing from a thread.\n");
    return 0;
}

int main(void) {
    printf("Starting thread.\n");
    HANDLE th;
    DWORD id;
    th = CreateThread(NULL, 0, thread_func, NULL, 0, &id);
    WaitForSingleObject(th, INFINITE);
    printf("Stopped thread.\n");
    return 0;
}
#else

#include<thread>
#include<cstdio>

void main_func(void) {
    printf("Printing from a thread.\n");
}

int main(void) {
    printf("Starting thread.\n");
    std::thread th(main_func);
    th.join();
    printf("Stopped thread.\n");
    return 0;
}

#endif
